/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class MMIOHandlerMemoryAccessControl
extends MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    private final int[] memoryProtection = new int[4];
    private int unknown10;
    private int unknown14;
    private int unknown18;
    private int unknown1C;
    private int unknown20;
    private int unknown24;
    private int unknown28;
    private int unknown2C;
    private int unknown30;
    private int unknown34;
    private int unknown38;
    private int unknown3C;
    private final int[] unknown40_to_7C = new int[16];

    public MMIOHandlerMemoryAccessControl(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.memoryProtection);
        this.unknown10 = stream.readInt();
        this.unknown14 = stream.readInt();
        this.unknown18 = stream.readInt();
        this.unknown1C = stream.readInt();
        this.unknown20 = stream.readInt();
        this.unknown24 = stream.readInt();
        this.unknown28 = stream.readInt();
        this.unknown2C = stream.readInt();
        this.unknown30 = stream.readInt();
        this.unknown34 = stream.readInt();
        this.unknown38 = stream.readInt();
        this.unknown3C = stream.readInt();
        stream.readInts(this.unknown40_to_7C);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.memoryProtection);
        stream.writeInt(this.unknown10);
        stream.writeInt(this.unknown14);
        stream.writeInt(this.unknown18);
        stream.writeInt(this.unknown1C);
        stream.writeInt(this.unknown20);
        stream.writeInt(this.unknown24);
        stream.writeInt(this.unknown28);
        stream.writeInt(this.unknown2C);
        stream.writeInt(this.unknown30);
        stream.writeInt(this.unknown34);
        stream.writeInt(this.unknown38);
        stream.writeInt(this.unknown3C);
        stream.writeInts(this.unknown40_to_7C);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.memoryProtection, 0);
        this.unknown10 = 0;
        this.unknown14 = 0;
        this.unknown18 = 0;
        this.unknown1C = 0;
        this.unknown20 = 0;
        this.unknown24 = 0;
        this.unknown28 = 0;
        this.unknown2C = 0;
        this.unknown30 = 0;
        this.unknown34 = 0;
        this.unknown38 = 0;
        this.unknown3C = 0;
        Arrays.fill(this.unknown40_to_7C, 0);
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.memoryProtection[0];
                break;
            }
            case 4: {
                value = this.memoryProtection[1];
                break;
            }
            case 8: {
                value = this.memoryProtection[2];
                break;
            }
            case 12: {
                value = this.memoryProtection[3];
                break;
            }
            case 16: {
                value = this.unknown10;
                break;
            }
            case 20: {
                value = this.unknown14;
                break;
            }
            case 24: {
                value = this.unknown18;
                break;
            }
            case 28: {
                value = this.unknown1C;
                break;
            }
            case 32: {
                value = this.unknown20;
                break;
            }
            case 36: {
                value = this.unknown24;
                break;
            }
            case 40: {
                value = this.unknown28;
                break;
            }
            case 44: {
                value = this.unknown2C;
                break;
            }
            case 48: {
                value = this.unknown30;
                break;
            }
            case 52: {
                value = this.unknown34;
                break;
            }
            case 56: {
                value = this.unknown38;
                break;
            }
            case 60: {
                value = this.unknown3C;
                break;
            }
            case 64: {
                value = this.unknown40_to_7C[0];
                break;
            }
            case 68: {
                value = this.unknown40_to_7C[1];
                break;
            }
            case 72: {
                value = this.unknown40_to_7C[2];
                break;
            }
            case 76: {
                value = this.unknown40_to_7C[3];
                break;
            }
            case 80: {
                value = this.unknown40_to_7C[4];
                break;
            }
            case 84: {
                value = this.unknown40_to_7C[5];
                break;
            }
            case 88: {
                value = this.unknown40_to_7C[6];
                break;
            }
            case 92: {
                value = this.unknown40_to_7C[7];
                break;
            }
            case 96: {
                value = this.unknown40_to_7C[8];
                break;
            }
            case 100: {
                value = this.unknown40_to_7C[9];
                break;
            }
            case 104: {
                value = this.unknown40_to_7C[10];
                break;
            }
            case 108: {
                value = this.unknown40_to_7C[11];
                break;
            }
            case 112: {
                value = this.unknown40_to_7C[12];
                break;
            }
            case 116: {
                value = this.unknown40_to_7C[13];
                break;
            }
            case 120: {
                value = this.unknown40_to_7C[14];
                break;
            }
            case 124: {
                value = this.unknown40_to_7C[15];
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.memoryProtection[0] = value;
                break;
            }
            case 4: {
                this.memoryProtection[1] = value;
                break;
            }
            case 8: {
                this.memoryProtection[2] = value;
                break;
            }
            case 12: {
                this.memoryProtection[3] = value;
                break;
            }
            case 16: {
                this.unknown10 = value;
                break;
            }
            case 20: {
                this.unknown14 = value;
                break;
            }
            case 24: {
                this.unknown18 = value;
                break;
            }
            case 28: {
                this.unknown1C = value;
                break;
            }
            case 32: {
                this.unknown20 = value;
                break;
            }
            case 36: {
                this.unknown24 = value;
                break;
            }
            case 40: {
                this.unknown28 = value;
                break;
            }
            case 44: {
                this.unknown2C = value;
                break;
            }
            case 48: {
                this.unknown30 = value;
                break;
            }
            case 52: {
                this.unknown34 = value;
                break;
            }
            case 56: {
                this.unknown38 = value;
                break;
            }
            case 60: {
                this.unknown3C = value;
                break;
            }
            case 64: {
                this.unknown40_to_7C[0] = value;
                break;
            }
            case 68: {
                this.unknown40_to_7C[1] = value;
                break;
            }
            case 72: {
                this.unknown40_to_7C[2] = value;
                break;
            }
            case 76: {
                this.unknown40_to_7C[3] = value;
                break;
            }
            case 80: {
                this.unknown40_to_7C[4] = value;
                break;
            }
            case 84: {
                this.unknown40_to_7C[5] = value;
                break;
            }
            case 88: {
                this.unknown40_to_7C[6] = value;
                break;
            }
            case 92: {
                this.unknown40_to_7C[7] = value;
                break;
            }
            case 96: {
                this.unknown40_to_7C[8] = value;
                break;
            }
            case 100: {
                this.unknown40_to_7C[9] = value;
                break;
            }
            case 104: {
                this.unknown40_to_7C[10] = value;
                break;
            }
            case 108: {
                this.unknown40_to_7C[11] = value;
                break;
            }
            case 112: {
                this.unknown40_to_7C[12] = value;
                break;
            }
            case 116: {
                this.unknown40_to_7C[13] = value;
                break;
            }
            case 120: {
                this.unknown40_to_7C[14] = value;
                break;
            }
            case 124: {
                this.unknown40_to_7C[15] = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

